/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public class WSConstants {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int WSDL_30 = 0;
    public static final int WSDL_30PATCH = 10;
    public static final int WSDL_31 = 20;
    public static final int WSDL_40 = 30;
    public static final int RM_SUPPORT_UNKNOWN = -1;
    public static final int RM_SUPPORT_NO = 0;
    public static final int RM_SUPPORT_YES = 1;
    public String P8BPM_NS_PREFIX = "http://www.filenet.com/ns/fnpe/2006/06/po/";
    public String P8BPM_NS_FAULT = this.P8BPM_NS_PREFIX + "faults";
    public String P8BPM_NS_GENERIC = this.P8BPM_NS_PREFIX + "schema/fn/basic";
    public String P8BPM_NS_WSDL_PREFIX = this.P8BPM_NS_PREFIX + "wsdl";
    public String P8BPM_NS_SCHEMA_PREFIX = this.P8BPM_NS_PREFIX + "schema";
    public static final String P8BPM_SOAP_ACTION_URI_DELIM = "!";
    public QName FAULT_INVALID_INVOCATION = new QName(this.P8BPM_NS_FAULT, "InvalidInvocation");
    public QName FAULT_INVALID_CREDENTIALS = new QName(this.P8BPM_NS_FAULT, "InvalidCredentials");
    public QName FAULT_INVALID_PARAMETERS = new QName(this.P8BPM_NS_FAULT, "InvalidParameters");
    public QName FAULT_MISSING_SOAP_ACTION = new QName(this.P8BPM_NS_FAULT, "MissingSoapAction");
    public QName FAULT_IGNORE_FOR_SYNCHRONOUS = new QName(this.P8BPM_NS_FAULT, "IgnoreForSynchronous");
    public QName FAULT_SYNC_OP_TIMED_OUT = new QName(this.P8BPM_NS_FAULT, "SynchronousOperationTimedOut");
    public QName FAULT_FORWARD_TIMED_OUT = new QName(this.P8BPM_NS_FAULT, "ForwardTimedOut");
    public QName FAULT_SYNC_ORPHANED_OBJECT = new QName(this.P8BPM_NS_FAULT, "SynchronousOperationOrphaned");
    public static final QName QNAME_WSSE_SECURITY = new QName("http://schemas.xmlsoap.org/ws/2002/12/secext", "Security");
    public static final QName QNAME_WSSE_USERNAME_TOKEN = new QName("http://schemas.xmlsoap.org/ws/2002/12/secext", "UsernameToken");
    public static final QName QNAME_WSSE_USERNAME = new QName("http://schemas.xmlsoap.org/ws/2002/12/secext", "Username");
    public static final QName QNAME_WSSE_PASSWORD = new QName("http://schemas.xmlsoap.org/ws/2002/12/secext", "Password");
    public static final QName QNAME_WSSE_200401_SECURITY = new QName("http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    public static final QName QNAME_WSSE_200401_USERNAME_TOKEN = new QName("http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    public static final QName QNAME_WSSE_200401_USERNAME = new QName("http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username");
    public static final QName QNAME_WSSE_200401_PASSWORD = new QName("http://www.docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
    public static final QName QNAME_WSSE2_200401_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    public static final QName QNAME_WSSE2_200401_USERNAME_TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    public static final QName QNAME_WSSE2_200401_USERNAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username");
    public static final QName QNAME_WSSE2_200401_PASSWORD = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password");
    public QName QNAME_REPLYHEADER = new QName(this.P8BPM_NS_GENERIC, "ReplyHeader");
    public String P8BPM_SCHEMA_REPLYHEADER = null;
    private static Hashtable s_wsConstants = new Hashtable();
    private static int s_defaultWSDLVersion = 30;
    private int m_wsdlVersion = s_defaultWSDLVersion;
    private boolean m_bValidateUsingSchema = true;
    private String m_iVal = "iVal";
    private String m_sVal = "sVal";
    private String m_bVal = "bVal";
    private String m_dVal = "dVal";
    private String m_fVal = "fVal";
    private String m_tVal = "tVal";
    private String m_xVal = "xVal";
    private String m_attRVal = "attRVal";
    private String m_attVal = "attVal";
    public String P8BPM_PREDEFINED_SCHEMA = null;
    public static final String WS_CLWO_API_VERSION = "P8-3.0-1";
    public static final int WS_CLWS_API_NTOCREATE = 92626;
    public static final String WS_CLWO_API_WFIDPREFIX = "~1";
    public static final String SOAPBODY_PLACEHOLDER = "placeholder";
    public static final String SOAPBODY_PLACEHOLDER_PREFIX = "fnpo";

    private void init() {
        this.initPrefix();
        this.initReplyHeader();
        this.initPredefinedSchema();
    }

    void initPrefix() {
        this.P8BPM_NS_FAULT = this.P8BPM_NS_PREFIX + "faults";
        this.P8BPM_NS_GENERIC = this.m_wsdlVersion >= 30 ? this.P8BPM_NS_PREFIX + "schema/fn/basic" : this.P8BPM_NS_PREFIX + "schema/basic";
        this.P8BPM_NS_WSDL_PREFIX = this.P8BPM_NS_PREFIX + "wsdl";
        this.P8BPM_NS_SCHEMA_PREFIX = this.P8BPM_NS_PREFIX + "schema";
        this.FAULT_INVALID_INVOCATION = new QName(this.P8BPM_NS_FAULT, "InvalidInvocation");
        this.FAULT_INVALID_CREDENTIALS = new QName(this.P8BPM_NS_FAULT, "InvalidCredentials");
        this.FAULT_INVALID_PARAMETERS = new QName(this.P8BPM_NS_FAULT, "InvalidParameters");
        this.FAULT_MISSING_SOAP_ACTION = new QName(this.P8BPM_NS_FAULT, "MissingSoapAction");
        this.FAULT_IGNORE_FOR_SYNCHRONOUS = new QName(this.P8BPM_NS_FAULT, "IgnoreForSynchronous");
        this.FAULT_SYNC_OP_TIMED_OUT = new QName(this.P8BPM_NS_FAULT, "SynchronousOperationTimedOut");
        this.QNAME_REPLYHEADER = new QName(this.P8BPM_NS_GENERIC, "ReplyHeader");
    }

    void initReplyHeader() {
        String endQuote = "\"\n";
        StringBuffer buf = new StringBuffer();
        buf.append("<xsd:schema elementFormDefault=\"qualified\"");
        buf.append("    targetNamespace=\"").append(this.P8BPM_NS_GENERIC).append("\"\n");
        buf.append("    xmlns:tns=\"").append(this.P8BPM_NS_GENERIC).append("\"\n");
        buf.append("    xmlns:wsa=\"").append("http://schemas.xmlsoap.org/ws/2003/03/addressing").append("\"\n");
        buf.append("    xmlns:xsd=\"").append("http://www.w3.org/2001/XMLSchema").append("\"\n");
        buf.append(">\n");
        buf.append("\t<xsd:import namespace=\"").append("http://schemas.xmlsoap.org/ws/2003/03/addressing").append("\"\n");
        buf.append("\t    schemaLocation=\"").append("http://schemas.xmlsoap.org/ws/2003/03/addressing").append("\"\n").append("/>\n");
        buf.append("    <xsd:element name=\"ReplyHeader\">\n");
        buf.append("        <xsd:annotation>");
        buf.append("            <xsd:documentation>Defines the header info for reply</xsd:documentation>");
        buf.append("        </xsd:annotation>\n");
        buf.append("        <xsd:complexType>\n");
        buf.append("            <xsd:sequence>\n");
        buf.append("                <xsd:element maxOccurs=\"1\" minOccurs=\"0\" ref=\"wsa:MessageID\"/>\n");
        buf.append("                <xsd:element maxOccurs=\"1\" minOccurs=\"0\" ref=\"wsa:ReplyTo\"/>\n");
        buf.append("            </xsd:sequence>\n");
        buf.append("        </xsd:complexType>\n");
        buf.append("    </xsd:element>\n");
        buf.append("</xsd:schema>\n");
        this.P8BPM_SCHEMA_REPLYHEADER = buf.toString();
    }

    private void initPredefinedSchema() {
        if (this.m_wsdlVersion == 0) {
            this.m_iVal = "Value";
            this.m_sVal = "Value";
            this.m_bVal = "Value";
            this.m_dVal = "Value";
            this.m_fVal = "Value";
            this.m_tVal = "Value";
            this.m_xVal = "Value";
            this.m_attRVal = "Value";
            this.m_attVal = "Value";
        }
        String endQuote = "\"\n";
        StringBuffer buf = new StringBuffer();
        buf.append("<xsd:schema elementFormDefault=\"qualified\"");
        buf.append("    targetNamespace=\"").append(this.P8BPM_NS_GENERIC).append("\"\n");
        buf.append("    xmlns:tns=\"").append(this.P8BPM_NS_GENERIC).append("\"\n");
        buf.append("    xmlns:xsd=\"").append("http://www.w3.org/2001/XMLSchema").append("\"\n");
        buf.append(">\n");
        buf.append("    <xsd:complexType name=\"stringArray\">\n");
        buf.append("        <xsd:sequence>\n");
        buf.append("            <xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\"\n");
        buf.append("                name=\"");
        buf.append(this.m_sVal);
        buf.append("\" nillable=\"true\" type=\"xsd:string\"/>\n");
        buf.append("        </xsd:sequence>\n");
        buf.append("    </xsd:complexType>\n");
        buf.append("    <xsd:element name=\"stringElement\" type=\"xsd:string\"/>\n");
        buf.append("    <xsd:complexType name=\"integerArray\">\n");
        buf.append("        <xsd:sequence>\n");
        buf.append("            <xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\"\n");
        buf.append("                name=\"");
        buf.append(this.m_iVal);
        buf.append("\" nillable=\"true\" type=\"xsd:int\"/>\n");
        buf.append("        </xsd:sequence>\n");
        buf.append("    </xsd:complexType>\n");
        buf.append("    <xsd:complexType name=\"booleanArray\">\n");
        buf.append("        <xsd:sequence>\n");
        buf.append("            <xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\"\n");
        buf.append("                name=\"");
        buf.append(this.m_bVal);
        buf.append("\" nillable=\"true\" type=\"xsd:boolean\"/>\n");
        buf.append("        </xsd:sequence>\n");
        buf.append("    </xsd:complexType>\n");
        buf.append("    <xsd:complexType name=\"doubleArray\">\n");
        buf.append("        <xsd:sequence>\n");
        buf.append("            <xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\"\n");
        buf.append("                name=\"");
        buf.append(this.m_dVal);
        buf.append("\" nillable=\"true\" type=\"xsd:double\"/>\n");
        buf.append("        </xsd:sequence>\n");
        buf.append("    </xsd:complexType>\n");
        buf.append("    <xsd:complexType name=\"floatArray\">\n");
        buf.append("        <xsd:sequence>\n");
        buf.append("            <xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\"\n");
        buf.append("                name=\"");
        buf.append(this.m_fVal);
        buf.append("\" nillable=\"true\" type=\"xsd:float\"/>\n");
        buf.append("        </xsd:sequence>\n");
        buf.append("    </xsd:complexType>\n");
        buf.append("    <xsd:complexType name=\"dateTimeArray\">\n");
        buf.append("        <xsd:sequence>\n");
        buf.append("            <xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\"\n");
        buf.append("                name=\"");
        buf.append(this.m_tVal);
        buf.append("\" nillable=\"true\" type=\"xsd:dateTime\"/>\n");
        buf.append("        </xsd:sequence>\n");
        buf.append("    </xsd:complexType>\n");
        buf.append("    <xsd:complexType name=\"xmlStringArray\">\n");
        buf.append("        <xsd:sequence>\n");
        buf.append("            <xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\"\n");
        buf.append("                name=\"");
        buf.append(this.m_xVal);
        buf.append("\" nillable=\"true\" type=\"xsd:string\"/>\n");
        buf.append("        </xsd:sequence>\n");
        buf.append("    </xsd:complexType>\n");
        buf.append("    <xsd:element name=\"xmlStringElement\" type=\"xsd:string\"/>\n");
        buf.append("    <xsd:complexType name=\"attachmentRefArray\">\n");
        buf.append("        <xsd:sequence>\n");
        buf.append("            <xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\"\n");
        buf.append("                name=\"");
        buf.append(this.m_attRVal);
        buf.append("\" nillable=\"true\" type=\"xsd:string\"/>\n");
        buf.append("        </xsd:sequence>\n");
        buf.append("    </xsd:complexType>\n");
        buf.append("    <xsd:element name=\"attachmentRefElement\" type=\"xsd:string\"/>\n");
        buf.append("    <xsd:complexType name=\"attachmentArray\">\n");
        buf.append("        <xsd:sequence>\n");
        buf.append("            <xsd:element maxOccurs=\"unbounded\" minOccurs=\"0\"\n");
        buf.append("                name=\"");
        buf.append(this.m_attVal);
        buf.append("\" nillable=\"true\" type=\"xsd:base64Binary\"/>\n");
        buf.append("        </xsd:sequence>\n");
        buf.append("    </xsd:complexType>\n");
        buf.append("</xsd:schema>\n");
        this.P8BPM_PREDEFINED_SCHEMA = buf.toString();
    }

    public WSConstants(int version, String namespace, boolean bValidateUsingSchema) {
        this.P8BPM_NS_PREFIX = namespace;
        this.m_wsdlVersion = version;
        this.m_bValidateUsingSchema = bValidateUsingSchema;
        this.init();
    }

    public WSConstants(int version, String namespace) {
        this(version, namespace, true);
    }

    public static WSConstants getWSConstants(int wsdlVersion) {
        Object obj;
        if (s_wsConstants != null && (obj = s_wsConstants.get(new Integer(wsdlVersion))) instanceof WSConstants) {
            return (WSConstants)obj;
        }
        return WSConstants.getDefaultWSConstants();
    }

    public static WSConstants getDefaultWSConstants() {
        return WSConstants.getWSConstants(s_defaultWSDLVersion);
    }

    public static int getDefaultWSDLVersion() {
        return s_defaultWSDLVersion;
    }

    public int getWSDLVersion() {
        return this.m_wsdlVersion;
    }

    public boolean getValidateUsingSchema() {
        return this.m_bValidateUsingSchema;
    }

    private void setValidateUsingSchema(boolean bValidate) {
        this.m_bValidateUsingSchema = bValidate;
    }

    public static WSConstants getWSConstant(String namespace) {
        if (namespace == null || namespace.length() == 0) {
            return null;
        }
        Enumeration enumerator = s_wsConstants.elements();
        String aNamespace = null;
        if (enumerator != null) {
            Object obj = null;
            while (enumerator.hasMoreElements()) {
                obj = enumerator.nextElement();
                if (obj == null || !(obj instanceof WSConstants) || (aNamespace = ((WSConstants)obj).P8BPM_NS_PREFIX) == null || namespace.indexOf(aNamespace) == -1) continue;
                return obj;
            }
        }
        return null;
    }

    public static WSConstants[] getAllWSConstants() {
        if (s_wsConstants != null && s_wsConstants.size() > 0) {
            WSConstants[] wsConstants = new WSConstants[s_wsConstants.size()];
            int i = 0;
            Enumeration enumerator = s_wsConstants.elements();
            if (enumerator != null) {
                Object obj = null;
                while (enumerator.hasMoreElements()) {
                    obj = enumerator.nextElement();
                    if (obj == null || !(obj instanceof WSConstants)) continue;
                    wsConstants[i++] = obj;
                }
            }
            return wsConstants;
        }
        return null;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10 Dec 2008 10:41:16  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.37  $";
    }

    public static String UTF8Encode(String s) {
        try {
            return URLEncoder.encode(s, DEFAULT_ENCODING);
        }
        catch (Exception exception) {
            return s;
        }
    }

    public static String UTF8Decode(String s) {
        try {
            return URLDecoder.decode(s, DEFAULT_ENCODING);
        }
        catch (Exception exception) {
            return s;
        }
    }

    public static boolean isLoopbackAddress(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return addr.isLoopbackAddress();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    static {
        s_wsConstants.put(new Integer(0), new WSConstants(0, "http://www.filenet.com/ns/fnpe/2004/06/po/", false));
        s_wsConstants.put(new Integer(10), new WSConstants(10, "http://www.filenet.com/ns/fnpe/2004/08/po/", false));
        s_wsConstants.put(new Integer(20), new WSConstants(20, "http://www.filenet.com/ns/fnpe/2004/12/po/"));
        s_wsConstants.put(new Integer(30), new WSConstants(30, "http://www.filenet.com/ns/fnpe/2006/06/po/"));
    }
}

